/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.servo.jmx;

import com.netflix.servo.MonitorRegistry;
import com.netflix.servo.jmx.MonitorMBean;
import com.netflix.servo.jmx.ObjectNameMapper;
import com.netflix.servo.monitor.Monitor;
import com.netflix.servo.monitor.MonitorConfig;
import com.netflix.servo.util.UnmodifiableList;
import java.lang.management.ManagementFactory;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.DynamicMBean;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JmxMonitorRegistry
implements MonitorRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JmxMonitorRegistry.class);
    private final MBeanServer mBeanServer;
    private final ConcurrentMap<MonitorConfig, Monitor<?>> monitors;
    private final String name;
    private final ObjectNameMapper mapper;
    private final ConcurrentMap<ObjectName, Object> locks = new ConcurrentHashMap<ObjectName, Object>();
    private final AtomicBoolean updatePending = new AtomicBoolean(false);
    private final AtomicReference<Collection<Monitor<?>>> monitorList = new AtomicReference<List<Monitor>>(UnmodifiableList.of(new Monitor[0]));

    public JmxMonitorRegistry(String name) {
        this(name, ObjectNameMapper.DEFAULT);
    }

    public JmxMonitorRegistry(String name, ObjectNameMapper mapper) {
        this.name = name;
        this.mapper = mapper;
        this.mBeanServer = ManagementFactory.getPlatformMBeanServer();
        this.monitors = new ConcurrentHashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(ObjectName objectName, DynamicMBean mbean) throws Exception {
        Object object = this.getLock(objectName);
        synchronized (object) {
            if (this.mBeanServer.isRegistered(objectName)) {
                this.mBeanServer.unregisterMBean(objectName);
            }
            this.mBeanServer.registerMBean(mbean, objectName);
        }
    }

    @Override
    public Collection<Monitor<?>> getRegisteredMonitors() {
        if (this.updatePending.getAndSet(false)) {
            this.monitorList.set(UnmodifiableList.copyOf(this.monitors.values()));
        }
        return this.monitorList.get();
    }

    @Override
    public void register(Monitor<?> monitor) {
        try {
            List<MonitorMBean> beans2 = MonitorMBean.createMBeans(this.name, monitor, this.mapper);
            for (MonitorMBean bean2 : beans2) {
                this.register(bean2.getObjectName(), bean2);
            }
            this.monitors.put(monitor.getConfig(), monitor);
            this.updatePending.set(true);
        }
        catch (Exception e) {
            LOG.warn("Unable to register Monitor:" + monitor.getConfig(), e);
        }
    }

    @Override
    public void unregister(Monitor<?> monitor) {
        try {
            List<MonitorMBean> beans2 = MonitorMBean.createMBeans(this.name, monitor, this.mapper);
            for (MonitorMBean bean2 : beans2) {
                try {
                    this.mBeanServer.unregisterMBean(bean2.getObjectName());
                    this.locks.remove(bean2.getObjectName());
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            this.monitors.remove(monitor.getConfig());
            this.updatePending.set(true);
        }
        catch (Exception e) {
            LOG.warn("Unable to un-register Monitor:" + monitor.getConfig(), e);
        }
    }

    @Override
    public boolean isRegistered(Monitor<?> monitor) {
        try {
            List<MonitorMBean> beans2 = MonitorMBean.createMBeans(this.name, monitor, this.mapper);
            for (MonitorMBean bean2 : beans2) {
                if (!this.mBeanServer.isRegistered(bean2.getObjectName())) continue;
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private Object getLock(ObjectName objectName) {
        return this.locks.computeIfAbsent(objectName, k -> new Object());
    }
}

