/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.infix;

import com.google.common.base.Objects;
import com.netflix.infix.ValuePredicate;
import javax.annotation.Nullable;

public class BooleanValuePredicate
implements ValuePredicate<Boolean> {
    private Boolean value;
    public static final BooleanValuePredicate TRUE = new BooleanValuePredicate(Boolean.TRUE);
    public static final BooleanValuePredicate FALSE = new BooleanValuePredicate(Boolean.FALSE);

    private BooleanValuePredicate(@Nullable Boolean value) {
        this.value = value;
    }

    @Override
    public boolean apply(@Nullable Boolean input) {
        return Objects.equal(this.value, input);
    }

    public Boolean getValue() {
        return this.value;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("BooleanValuePredicate [value=");
        builder.append(this.value);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BooleanValuePredicate other = (BooleanValuePredicate)obj;
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

