/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.discovery;

import com.netflix.appinfo.AmazonInfo;
import com.netflix.appinfo.DataCenterInfo;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AzToRegionMapper;
import jakarta.annotation.Nullable;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceRegionChecker {
    private static Logger logger = LoggerFactory.getLogger(InstanceRegionChecker.class);
    private final AzToRegionMapper azToRegionMapper;
    private final String localRegion;

    InstanceRegionChecker(AzToRegionMapper azToRegionMapper, String localRegion) {
        this.azToRegionMapper = azToRegionMapper;
        this.localRegion = localRegion;
    }

    @Nullable
    public String getInstanceRegion(InstanceInfo instanceInfo) {
        AmazonInfo amazonInfo;
        Map<String, String> metadata;
        String availabilityZone;
        if (instanceInfo.getDataCenterInfo() == null || instanceInfo.getDataCenterInfo().getName() == null) {
            logger.warn("Cannot get region for instance id:{}, app:{} as dataCenterInfo is null. Returning local:{} by default", instanceInfo.getId(), instanceInfo.getAppName(), this.localRegion);
            return this.localRegion;
        }
        if (DataCenterInfo.Name.Amazon.equals((Object)instanceInfo.getDataCenterInfo().getName()) && null != (availabilityZone = (metadata = (amazonInfo = (AmazonInfo)instanceInfo.getDataCenterInfo()).getMetadata()).get(AmazonInfo.MetaDataKey.availabilityZone.getName()))) {
            return this.azToRegionMapper.getRegionForAvailabilityZone(availabilityZone);
        }
        return null;
    }

    public boolean isLocalRegion(@Nullable String instanceRegion) {
        return null == instanceRegion || instanceRegion.equals(this.localRegion);
    }

    public String getLocalRegion() {
        return this.localRegion;
    }

    public AzToRegionMapper getAzToRegionMapper() {
        return this.azToRegionMapper;
    }
}

