package Scanner;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

public class IpPortsScanner {
    public static Future<IpAddress> ipScanner(ExecutorService executorService, String ipAddress, int startPort, int endPort) {
        return executorService.submit(new Callable<IpAddress>() {
            @Override
            public IpAddress call() throws Exception {
                List<Future<Port>> futureList = new ArrayList<>();
                List<Port> resultList = new ArrayList<>();
                int threadCount = Runtime.getRuntime().availableProcessors();
                ExecutorService executorService1 = Executors.newFixedThreadPool(threadCount);
                for (int currPort = startPort; currPort <= endPort; currPort++) {
                    futureList.add(PortScanner.isPortOpen(executorService1, ipAddress, currPort));
                }
                executorService1.shutdown();
                for (Future<Port> eachFuture : futureList) {
                    try {
                        resultList.add(eachFuture.get(2, TimeUnit.MINUTES));
                    } catch (Exception e) {
                        System.err.println("Timeout reached");
                        System.exit(1);
                    }
                }
                IpAddress IP = new IpAddress(ipAddress);
                for (Port port : resultList) {
                    if (port.isOpen) {
                        IP.getOpenPortList().add(port);
                    } else {
                        IP.getClosedPortList().add(port);
                    }
                }
                return IP;
            }
        });
    }
}
