package Scanner;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

public class IpAddress {
    private String ipAddress;
    private List<Port> openPortList;
    private List<Port> closedPortList;

    public IpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
        closedPortList = new ArrayList<>();
        openPortList = new ArrayList<>();
    }

    public String getIpAddress() {
        return ipAddress;
    }

    public List<Port> getOpenPortList() {
        return openPortList;
    }

    public List<Port> getClosedPortList() {
        return closedPortList;
    }

    public static InetAddress incrementIpAddress(InetAddress ip) {

        byte[] address = ip.getAddress();
        for (int i = address.length - 1; i >= 0; i--) {
            if ((address[i] & 0xFF) < 255) {
                address[i]++;
                break;
            } else {
                address[i] = 0;
            }
        }
        try {
            ip = InetAddress.getByAddress(address);
        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        return ip;

    }
}
