package Scanner;

import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
public class PortScanner {
    public static Future<Port> isPortOpen(ExecutorService executorService, String ipAddress, int portNumber) {
        return executorService.submit(new Callable<Port>() {
            @Override
            public Port call() {
                Port port = new Port(portNumber,false);
                try (Socket sfd = new Socket()) {
                    sfd.connect(new InetSocketAddress(ipAddress, portNumber), 100);
                    port.isOpen=true;
                } catch (Exception e) {}

                return port;
            }
        });
    }

}

