import Scanner.Port;
import Scanner.IpPortsScanner;
import Scanner.IpAddress;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class ScannerService {


    public static void main(String[] args) {
        Scanner input = new Scanner(System.in);
        String startIP;

        //Enter start IP address of range and validate it
        while (true) {
            try {
                System.out.println("Enter Start IP");
                startIP = input.next();
                IPValidator.validateIPAddress(startIP);
                break;
            } catch (InvalidException I) {
                System.out.println("Exception occurred: " + I.getMessage());
            }
        }
        String endIP;

        //Enter end IP address of range and validate it
        while (true) {
            try {
                System.out.println("Enter End IP");
                endIP = input.next();
                IPValidator.validateIPAddress(endIP);
                break;
            } catch (InvalidException I) {
                System.out.println("Exception occurred: " + I.getMessage());
            }
        }

        int startPort;
        //Enter start Port number of range and validate it
        while (true) {
            try {
                System.out.println("Enter Start port");
                startPort = input.nextInt();
                PortValidator.validatePort(startPort);
                break;
            }catch (InvalidException I){
                System.out.println("Exception occurred: " + I.getMessage());

            }
        }

        int endPort;
        //Enter end Port number of range and validate it
        while (true) {
            try {
                System.out.println("Enter end port");
                endPort = input.nextInt();
                PortValidator.validatePort(endPort);
                break;
            }catch (InvalidException I){
                System.out.println("Exception occurred: " + I.getMessage());

            }
        }

        int threadCount = Runtime.getRuntime().availableProcessors();
        List<Future<IpAddress>> futureList = new ArrayList<>();
        //List of ip objects each of it contain list of open ports
        List<IpAddress> ipResultList = new ArrayList<>();


        ExecutorService executorService = Executors.newFixedThreadPool(threadCount);
        try {
            InetAddress startAddress = InetAddress.getByName(startIP);
            InetAddress endAddress = InetAddress.getByName(endIP);

            // pass over ip range
            while (!startAddress.equals(endAddress)) {
                String ip = startAddress.getHostAddress();

                // submit task to executor when we call the function IpPortsScanner.ipScanner(executorService, ip, startPort, endPort)
                futureList.add(IpPortsScanner.ipScanner(executorService, ip, startPort, endPort));
                startAddress = IpAddress.incrementIpAddress(startAddress);
            }

        } catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        executorService.shutdown();


        // cast future<Ipaddress> to List<Ipaddress>
        for (Future<IpAddress> eachFuture : futureList) {
            try {
                ipResultList.add(eachFuture.get(2, TimeUnit.MINUTES));
            } catch (Exception e) {
                System.err.println("Timeout reached");
                System.exit(1);
            }
        }

        for (IpAddress ip : ipResultList) {
            for (Port port : ip.getOpenPortList()) {
                System.out.println("for ip address " + ip.getIpAddress());
                port.print();
            }

        }
    }
}
