public class IPValidator {
    public static void validateIPAddress(String ipAddress) throws InvalidException {
        // Perform IP address validation logic
        if (!isValidIPAddress(ipAddress)) {
            throw new InvalidException("Invalid IP address: " + ipAddress + "\n It should be 4 bytes like xxx.xxx.xxx.xxx" );
        }
    }

    private static boolean isValidIPAddress(String ipAddress) {
        // Split the IP address into octets
        String[] octets = ipAddress.split("\\.");

        // Check if the IP address consists of four octets
        if (octets.length != 4) {
            return false;
        }

        // Check each octet for validity
        for (String octet : octets) {
            try {
                // Parse the octet as an integer
                int value = Integer.parseInt(octet);

                // Check if the octet is within the valid range (0-255)
                if (value < 0 || value > 255) {
                    return false;
                }
            } catch (NumberFormatException e) {
                // If the octet is not a valid integer
                return false;
            }
        }

        // If all checks pass, the IP address is valid
        return true;
    }
}