package Count;

import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import java.io.IOException;

public class URLReducer extends Reducer<Text, IntWritable, Text, DoubleWritable> {
    private DoubleWritable result = new DoubleWritable();

    // Variable to store the total count of URL accesses
    private long totalCount = 0;

    public void reduce(Text key, Iterable<IntWritable> values, Context context) throws IOException, InterruptedException {
        int sum = 0;
        // Iterate through the values (counts) for the current URL key
        for (IntWritable val : values) {
            // Sum up the counts
            sum += val.get();
            // Increment the total count
            totalCount += val.get();
        }
        // Calculate the percentage frequency of the URL
        double frequency = ((double) sum / totalCount) * 100;
        result.set(frequency); // Set the result as the calculated frequency
        context.write(key, result); // Write the URL and its frequency to the output
    }
}
