package Count;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.GenericOptionsParser;

public class URLAccessFrequency {
    public static void main(String[] args) throws Exception {
        // Create a new Configuration object to hold Hadoop configuration settings
        Configuration conf = new Configuration();

        // Parse the command line arguments to get input and output file paths
        String[] files = new GenericOptionsParser(conf, args).getRemainingArgs();
        Path input = new Path(files[0]); // Input file path
        Path output = new Path(files[1]); // Output file path

        // Create a new MapReduce job with the configuration and a job name
        Job job = new Job(conf, "URL_Access_Frequency");

        // Set the main class for the job JAR file
        job.setJarByClass(URLAccessFrequency.class);

        // Set the Mapper and Reducer classes for the job
        job.setMapperClass(URLMapper.class); // Mapper class
        job.setCombinerClass(URLReducer.class); // Optional combiner class for optimization
        job.setReducerClass(URLReducer.class); // Reducer class

        // Set the output key and value classes for the job
        job.setOutputKeyClass(Text.class); // Output key class
        job.setOutputValueClass(IntWritable.class); // Output value class

        // Set the input and output file paths for the job
        FileInputFormat.addInputPath(job, input); // Input file path
        FileOutputFormat.setOutputPath(job, output); // Output file path

        // Execute the job and wait for completion
        System.exit(job.waitForCompletion(true) ? 0 : 1);
    }
}
