package Count;

import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

import java.io.IOException;

public class URLMapper extends Mapper<LongWritable, Text, Text, IntWritable> {
    private final static IntWritable one = new IntWritable(1);
    private Text url = new Text();

    public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
        // Split the input value by space
        String[] fields = value.toString().split(" ");
        if (fields.length >= 1) {
            // Assuming URL is the first field
            url.set(fields[0]);
            // Emit (url, 1) as key-value pair
            context.write(url, one);
        }
    }
}
